<?php
/**
 * Modul Ověřeno zákazníky Heureka.cz pro PrestaShop 1.4
 * @category admin
 *
 * @author Lukáš Krchňák <lukas.krchnak@uniqueweb.cz> www.uniqueweb.cz
 * @copyright © 2012 Lukáš Krchňák
 * @license All rights reserved
 * @version 1.0
 *  
 * The buyer can free use/edit/modify this software in anyway
 * The buyer is NOT allowed to redistribute this module in anyway or resell it or redistribute it to third party
 *  
 */

if (!defined('_PS_VERSION_'))
	exit;

class HeurekaOvereno extends Module
{	
	function __construct()
	{
	 	$this->name = 'heurekaovereno';
	 	$this->tab = 'analytics_stats';
	 	$this->version = '1.0';
		$this->author = 'UniqueWeb.cz Lukáš Krchňák';
		$this->displayName = 'Ověřeno zákazníky - Heureka.cz';
		
	 	parent::__construct();
		
		if ($this->id AND !Configuration::get('HEUREKA_OVERENO_ID'))
		$this->warning = $this->l('You have not yet set your Heureka API key');
		$this->description = $this->l('Integrate Heureka script into your shop');
		$this->confirmUninstall = $this->l('Are you sure you want to delete your details ?');

		/** Backward compatibility */
		require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
    require_once(_PS_MODULE_DIR_.$this->name.'/HeurekaOverenoClass.php');
	}

	function install()
	{
		if (!parent::install() OR
				!$this->registerHook('orderConfirmation') OR
			  !Configuration::updateValue('HEUREKA_OVERENO_SK', 0))
			return false;
		return true;
	}
  
  public function uninstall()
	{
		if (!parent::uninstall() OR
			!Configuration::deleteByName('HEUREKA_OVERENO_ID') OR
			!Configuration::deleteByName('HEUREKA_OVERENO_SK'))
			return false;
		return true;
	}
	
	public function getContent()
	{
		$output = '<h2>'.$this->l('Ověřeno zákazníky - Heuréka').'</h2>';
		if (Tools::isSubmit('submitHeureka'))
		{
      $hapi = Tools::getValue('heureka_id');
      $hsk = Tools::getValue('SLOVAK_HEUREKA');
			Configuration::updateValue('HEUREKA_OVERENO_ID', $hapi);
      Configuration::updateValue('HEUREKA_OVERENO_SK', (int)($hsk));
			$output .= '
			<div class="conf confirm">
				<img src="../img/admin/ok.gif" alt="" title="" />
				'.$this->l('Settings updated').'
			</div>';
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{           
		$output = '	<div>Tento modul Vám umožní získat zpětnou vazbu od zákazníků, kteří u Vás uskuteční objednávku.</div>    <br />
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset class="width2">
				<legend><img src="../modules/'.$this->name.'/logo.gif" alt="" class="middle" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Heureka API key').'</label>
				<div class="margin-form">
					<input type="text" name="heureka_id" size="44" value="'.Tools::safeOutput(Tools::getValue('heureka_id', Configuration::get('HEUREKA_OVERENO_ID'))).'" />
					<p class="clear">'.$this->l('Example:').' ABCDEFGH12345NOPQRS1111123456789</p>
				</div>
        <label for="SLOVAK_HEUREKA_on">'.$this->l('Slovak eshop domain:').'</label>
			<div class="margin-form">
				<img src="../img/admin/enabled.gif" alt="Yes" title="Yes" />
		        <input type="radio" name="SLOVAK_HEUREKA" id="SLOVAK_HEUREKA_on" ' . (((Tools::getValue('SLOVAK_HEUREKA', Configuration::get('HEUREKA_OVERENO_SK'))) == '1') ? 'checked="checked" ' : ''). 'value="1" />
			    <label class="t" for="SLOVAK_HEUREKA_on">'.$this->l('Yes').'</label>
			    <img src="../img/admin/disabled.gif" alt="No" title="No" style="margin-left: 10px;" />
			    <input type="radio" name="SLOVAK_HEUREKA" id="SLOVAK_HEUREKA_off"' . (((Tools::getValue('SLOVAK_HEUREKA', Configuration::get('HEUREKA_OVERENO_SK'))) == '0') ? 'checked="checked" ' : ''). 'value="0" />
			    <label  class="t" for="SLOVAK_HEUREKA_off">'.$this->l('No').'</label><br /><br />'
				.$this->l('Check if use Heureka.sk').
		  '</div>
				<center><input type="submit" name="submitHeureka" value="'.$this->l('Update API key').'" class="button" /></center>
			</fieldset>
		</form>';

		return $output;
	}

	function hookOrderConfirmation($params)
	{
	   
    global $cookie;
    
    $order = $params['objOrder'];
    
		if (Validate::isLoadedObject($order))
		{
        try  
        {
            $customer = new Customer((int)($cookie->id_customer));
            
            if (Configuration::get('HEUREKA_OVERENO_SK') == '0'){   
              $overeno = new HeurekaOverenoClass(Configuration::get('HEUREKA_OVERENO_ID'));
            }else{
              // pro slovenske obchody ;
              $overeno = new HeurekaOverenoClass(Configuration::get('HEUREKA_OVERENO_ID'), HeurekaOvereno::LANGUAGE_SK);
            }
                                     
            $overeno->setEmail($customer->email);
            
            // Product information
    			  $products = $order->getProducts();
    			  foreach ($products AS $product)
    			  {       
              $overeno->addProduct($product['product_name']);
            }
            
            $overeno->send();
            
        } catch (Exception $e) {
           
            print $e->getMessage();
        
        }
        
     }     
    
	}
}
